/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.particle.configurations.properties;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.DocClientUtils;
import com.hollingsworth.arsnouveau.api.particle.configurations.ListParticleWidgetProvider;
import com.hollingsworth.arsnouveau.api.particle.configurations.ParticleConfigWidgetProvider;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.BaseProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.IPropertyType;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.PropMap;
import com.hollingsworth.arsnouveau.api.registry.ParticlePropertyRegistry;
import com.hollingsworth.arsnouveau.client.gui.documentation.DocEntryButton;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public class RuneTextureProperty
extends BaseProperty<RuneTextureProperty> {
    public static final List<String> TEXTURES = new CopyOnWriteArrayList<String>();
    public String runeTexture;
    public static MapCodec<RuneTextureProperty> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("texture").forGetter(i -> i.runeTexture)).apply((Applicative)instance, RuneTextureProperty::new));
    public static StreamCodec<RegistryFriendlyByteBuf, RuneTextureProperty> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, i -> i.runeTexture, RuneTextureProperty::new);

    public RuneTextureProperty(String string) {
        super(new PropMap());
        this.runeTexture = TEXTURES.stream().filter(r -> r.equals(string)).findFirst().orElse(TEXTURES.get(0));
    }

    public RuneTextureProperty() {
        super(new PropMap());
        this.runeTexture = TEXTURES.get(0);
    }

    @Override
    public ParticleConfigWidgetProvider buildWidgets(int x, int y, int width, int height) {
        ArrayList<DocEntryButton> buttons = new ArrayList<DocEntryButton>();
        for (int i = 0; i < TEXTURES.size(); ++i) {
            String texture = TEXTURES.get(i);
            DocEntryButton button = new DocEntryButton(x, y + 20 + 15 * i, ItemStack.EMPTY, this.getPatternName(texture), b -> {
                this.runeTexture = texture;
                this.onDependenciesChanged.run();
            }).withStaticIcon(new DocAssets.BlitInfo(ArsNouveau.prefix("textures/block/runes/" + texture + ".png"), 16, 16));
            buttons.add(button);
        }
        return new ListParticleWidgetProvider(x, y, width, height, buttons, 8, () -> this.providerData){

            @Override
            public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                DocClientUtils.drawHeader(RuneTextureProperty.this.getName(), graphics, this.x, this.y, this.width, mouseX, mouseY, partialTicks);
            }

            @Override
            public void renderIcon(GuiGraphics graphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
                graphics.blit(ArsNouveau.prefix("textures/block/runes/" + RuneTextureProperty.this.runeTexture + ".png"), x + 1, y + 1, 0.0f, 0.0f, 12, 12, 12, 12);
            }

            @Override
            public Component getButtonTitle() {
                return Component.literal((String)(RuneTextureProperty.this.getName().getString() + ": " + RuneTextureProperty.this.getPatternName(RuneTextureProperty.this.runeTexture).getString()));
            }
        };
    }

    private Component getPatternName(String pattern) {
        return Component.translatable((String)("ars_nouveau.rune." + pattern));
    }

    @Override
    public IPropertyType<RuneTextureProperty> getType() {
        return (IPropertyType)ParticlePropertyRegistry.RUNE_PROPERTY.get();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuneTextureProperty that = (RuneTextureProperty)o;
        return Objects.equals(this.runeTexture, that.runeTexture);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.runeTexture);
    }

    static {
        TEXTURES.add("rune");
        TEXTURES.add("rune_abjuration");
        TEXTURES.add("rune_conjuration");
        TEXTURES.add("rune_air");
        TEXTURES.add("rune_earth");
        TEXTURES.add("rune_fire");
        TEXTURES.add("rune_water");
        TEXTURES.add("rune_manipulation");
    }
}

